#!/sbin/sh

uninstall_package() {
    # Remove the files when we're uninstalling NiKGapps
    for i in $file_list; do
        uninstall_file "$i" "$package_title"
    done
    # Removing the addon sh so it doesn't get backed up and restored
    for i in $(find /system/addon.d -iname "*$package_title.sh" 2>/dev/null;); do
      if [ -f "$i" ]; then
        addToLog "- Removing $i" "$package_title"
        rm -rf "$i"
      fi
    done
    # Removing the updates and residue
    if [ -n "$2" ]; then
        for i in $(find /data -iname "*$2*" 2>/dev/null); do
            if [ -e "$i" ] || [ -d "$1"]; then
                addToLog "- contents matching $2 found at $i"
                rm -rf "$i"
            fi
        done
    fi
}

# Initialize the variables
clean_flash_only="false"
title="ExtraFiles"
package_title="ExtraFiles"
package_name=""

file_list="
___etc___default-permissions/default-permissions-nikgapps.xml
___lib/libjni_latinimegoogle.so
___etc___sysconfig/preinstalled-packages-product-pixel-2017-and-newer.xml
___etc___sysconfig/google-staged-installer-whitelist.xml
___etc___sysconfig/game_service.xml
___etc___sysconfig/quick_tap.xml
___etc___sysconfig/nexus.xml
___etc___sysconfig/nga.xml
___etc___sysconfig/dreamliner.xml
___etc___sysconfig/d2d_cable_migration_feature.xml
___etc___sysconfig/GoogleCamera_6gb_or_more_ram.xml
___etc___sysconfig/adaptivecharging.xml
___etc___sysconfig/google.xml
___etc___sysconfig/google-hiddenapi-package-whitelist.xml
___etc___sysconfig/pixel_experience_2017.xml
___etc___sysconfig/google_build.xml
___etc___sysconfig/google-install-constraints-package-allowlist.xml
___lib64/libjni_latinimegoogle.so
___lib64/libgdx.so
___etc___permissions/NikGapps-privapp-permissions-google.xml
___etc___permissions/split-permissions-google.xml
___etc___permissions/privapp-permissions-google-p.xml
___etc___security___fsverity/play_store_fsi_cert.der
___etc___security___fsverity/gms_fsverity_cert.der
___framework/com.google.android.dialer.support.jar
___framework/com.google.android.maps.jar
"

uninstall_package
