#!/sbin/sh

uninstall_package() {
    # Remove the files when we're uninstalling NiKGapps
    for i in $file_list; do
        uninstall_file "$i" "$package_title"
    done
    # Removing the addon sh so it doesn't get backed up and restored
    for i in $(find /system/addon.d -iname "*$package_title.sh" 2>/dev/null;); do
      if [ -f "$i" ]; then
        addToLog "- Removing $i" "$package_title"
        rm -rf "$i"
      fi
    done
    # Removing the updates and residue
    if [ -n "$2" ]; then
        for i in $(find /data -iname "*$2*" 2>/dev/null); do
            if [ -e "$i" ] || [ -d "$1"]; then
                addToLog "- contents matching $2 found at $i"
                rm -rf "$i"
            fi
        done
    fi
}

# Initialize the variables
clean_flash_only="false"
title="GoogleSheets"
package_title="GoogleSheets"
package_name="com.google.android.apps.docs.editors.sheets"

file_list="
___app___GoogleSheets___lib___arm64/libritz_ndk1.so
___app___GoogleSheets___lib___arm64/libcello_native.so
___app___GoogleSheets___lib___arm64/libnative_crash_handler_jni.so
___app___GoogleSheets___lib___arm64/libwoff2_jni.so
___app___GoogleSheets/GoogleSheets.apk
___app___GoogleSheets/split_config.en.apk
"

uninstall_package
