#!/sbin/sh
configValue="$1"
nikgapps_config_file_name="$2"
install_partition="$3"

make_dir() {
  addToLog "- Creating Directory: $install_partition/$1" "$package_title"
  mkdir -p "$install_partition/$1"
  set_perm 1000 1000 0755 "$install_partition/$1"
}
# Initialize the variables
default_partition="product"
clean_flash_only="true"
product_prefix=$(find_product_prefix "$install_partition")
title="SoundPickerPrebuilt"
package_title="GoogleSounds"
pkg_size="5949"
package_name="com.google.android.soundpicker"
packagePath=installGoogleSoundsFiles
deleteFilesPath=deleteGoogleSoundsFiles
propFilePath=$(get_prop_file_path $package_title)

remove_aosp_apps_from_rom="
"

delete_overlays="
"

file_list="
___app___SoundPickerPrebuilt/SoundPickerPrebuilt.apk
"

remove_overlays() {
   for i in $delete_overlays; do
       delete_overlays "$i" "$propFilePath" "$package_title" 
   done
}

remove_existing_package() {
   # remove the existing folder for clean install of GoogleSounds
   delete_package "SoundPickerPrebuilt" "$package_title" 
}

remove_aosp_apps() {
   # Delete the folders that we want to remove with installing GoogleSounds
   for i in $remove_aosp_apps_from_rom; do
       RemoveAospAppsFromRom "$i" "$propFilePath" "$package_title" 
   done
}

install_package() {
   remove_existing_package
   remove_aosp_apps
   remove_overlays
   # Create folders and set the permissions
   make_dir "app"
   make_dir "app/SoundPickerPrebuilt"

   delete_prop_lines "$propFilePath"

   # Copy the files and set the permissions
   for i in $file_list; do
       install_file "$i"
   done

   chmod 755 "$COMMONDIR/addon";
   update_prop "$propFilePath" "install" "$propFilePath" "GoogleSounds" 
   . $COMMONDIR/addon "GoogleSounds" "$propFilePath" "09"
   copy_file "$propFilePath" "$logDir/addonfiles/$package_title.prop"
}

find_install_mode

