#!/sbin/sh
configValue="$1"
nikgapps_config_file_name="$2"
install_partition="$3"

make_dir() {
  addToLog "- Creating Directory: $install_partition/$1" "$package_title"
  mkdir -p "$install_partition/$1"
  set_perm 1000 1000 0755 "$install_partition/$1"
}
# Initialize the variables
default_partition="system_ext"
clean_flash_only="false"
product_prefix=$(find_product_prefix "$install_partition")
title="NexusLauncherRelease"
package_title="PixelLauncher"
pkg_size="14698"
package_name="com.google.android.apps.nexuslauncher"
packagePath=installPixelLauncherFiles
deleteFilesPath=deletePixelLauncherFiles
propFilePath=$(get_prop_file_path $package_title)

remove_aosp_apps_from_rom="
TrebuchetQuickStep
Launcher3QuickStep
ArrowLauncher
Lawnchair
"

delete_overlays="
Lawnchair
"

file_list="
___etc___sysconfig/hiddenapi-whitelist-com.google.android.apps.nexuslauncher.xml
___etc___sysconfig/preinstalled-packages-platform-overlays.xml
___priv-app___NexusLauncherRelease/NexusLauncherRelease.apk
___etc___permissions/privapp-permissions-com.google.android.apps.nexuslauncher.xml
___etc___permissions/com.google.android.apps.nexuslauncher.xml
___overlay/ThemedIconsOverlay.apk
___overlay/PixelLauncherOverlay.apk
"

remove_overlays() {
   for i in $delete_overlays; do
       delete_overlays "$i" "$propFilePath" "$package_title" 
   done
}

remove_existing_package() {
   # remove the existing folder for clean install of PixelLauncher
   delete_package "NexusLauncherRelease" "$package_title" 
}

remove_aosp_apps() {
   # Delete the folders that we want to remove with installing PixelLauncher
   for i in $remove_aosp_apps_from_rom; do
       RemoveAospAppsFromRom "$i" "$propFilePath" "$package_title" 
   done
}

install_package() {
   remove_existing_package
   remove_aosp_apps
   remove_overlays
   # Create folders and set the permissions
   make_dir "etc/sysconfig"
   make_dir "priv-app/NexusLauncherRelease"
   make_dir "etc/permissions"

   delete_prop_lines "$propFilePath"

   # Copy the files and set the permissions
   for i in $file_list; do
       install_file "$i"
   done

   chmod 755 "$COMMONDIR/addon";
   update_prop "$propFilePath" "install" "$propFilePath" "PixelLauncher" 
   . $COMMONDIR/addon "PixelLauncher" "$propFilePath" "09"
   copy_file "$propFilePath" "$logDir/addonfiles/$package_title.prop"
}

find_install_mode

