#!/sbin/sh
configValue="$1"
nikgapps_config_file_name="$2"
install_partition="$3"

make_dir() {
  addToLog "- Creating Directory: $install_partition/$1" "$package_title"
  mkdir -p "$install_partition/$1"
  set_perm 1000 1000 0755 "$install_partition/$1"
}
# Initialize the variables
default_partition="system_ext"
clean_flash_only="false"
product_prefix=$(find_product_prefix "$install_partition")
title="PixelSetupWizard"
package_title="PixelSetupWizard"
pkg_size="6395"
package_name="com.google.android.pixel.setupwizard"
packagePath=installPixelSetupWizardFiles
deleteFilesPath=deletePixelSetupWizardFiles
propFilePath=$(get_prop_file_path $package_title)

remove_aosp_apps_from_rom="
LineageSetupWizard
"

delete_overlays="
"

file_list="
___priv-app___PixelSetupWizard/PixelSetupWizard.apk
___overlay/PixelConfigOverlay2021.apk
___overlay/PixelConfigOverlayWallpaper.apk
___overlay/PixelConfigOverlay2018.apk
___overlay/PixelConfigOverlay2019.apk
___overlay/PixelConfigOverlay2019Midyear.apk
___overlay/PixelSetupWizardOverlay2019.apk
___overlay/PixelSetupWizardOverlay.apk
___overlay/PixelConfigOverlayCommon.apk
___etc___permissions/com.google.android.pixel.setupwizard.xml
"

remove_overlays() {
   for i in $delete_overlays; do
       delete_overlays "$i" "$propFilePath" "$package_title" 
   done
}

remove_existing_package() {
   # remove the existing folder for clean install of PixelSetupWizard
   delete_package "PixelSetupWizard" "$package_title" 
}

remove_aosp_apps() {
   # Delete the folders that we want to remove with installing PixelSetupWizard
   for i in $remove_aosp_apps_from_rom; do
       RemoveAospAppsFromRom "$i" "$propFilePath" "$package_title" 
   done
}

install_package() {
   remove_existing_package
   remove_aosp_apps
   remove_overlays
   # Create folders and set the permissions
   make_dir "priv-app/PixelSetupWizard"

   delete_prop_lines "$propFilePath"

   # Copy the files and set the permissions
   for i in $file_list; do
       install_file "$i"
   done

   chmod 755 "$COMMONDIR/addon";
   update_prop "$propFilePath" "install" "$propFilePath" "PixelSetupWizard" 
   . $COMMONDIR/addon "PixelSetupWizard" "$propFilePath" "09"
   copy_file "$propFilePath" "$logDir/addonfiles/$package_title.prop"
}

find_install_mode

