#!/sbin/sh
configValue="$1"
nikgapps_config_file_name="$2"
install_partition="$3"

make_dir() {
  addToLog "- Creating Directory: $install_partition/$1" "$package_title"
  mkdir -p "$install_partition/$1"
  set_perm 1000 1000 0755 "$install_partition/$1"
}
# Initialize the variables
default_partition="product"
clean_flash_only="true"
product_prefix=$(find_product_prefix "$install_partition")
title="LatinIMEGooglePrebuilt"
package_title="GBoard"
pkg_size="188739"
package_name="com.google.android.inputmethod.latin"
packagePath=installGBoardFiles
deleteFilesPath=deleteGBoardFiles
propFilePath=$(get_prop_file_path $package_title)

remove_aosp_apps_from_rom="
LatinIME
"

delete_overlays="
"

file_list="
___usr___srec___en-US/g2p_phonemes.syms
___usr___srec___en-US/g2p
___usr___srec___en-US/config.pumpkin
___usr___srec___en-US/SODA_punctuation_config.pb
___usr___srec___en-US/g2p.syms
___usr___srec___en-US/hotword.data
___usr___srec___en-US/semantics.pumpkin
___usr___srec___en-US/offline_action_data.pb
___usr___srec___en-US/metadata
___usr___srec___en-US/monastery_config.pumpkin
___usr___srec___en-US/SODA_punctuation_model.tflite
___usr___srec___en-US/pumpkin.mmap
___usr___srec___en-US/magic_mic/MARBLE_V2_acoustic_model.int8.tflite
___usr___srec___en-US/magic_mic/MARBLE_V2_model.int8.tflite
___usr___srec___en-US/magic_mic/MARBLE_V2_vocabulary.syms
___usr___srec___en-US/magic_mic/MARBLE_V2_acoustic_meanstddev_vector
___usr___srec___en-US/acousticmodel/MARBLE_VOICE_ACTIONS_EP.endpointer_portable_lstm_mean_stddev
___usr___srec___en-US/acousticmodel/MARBLE_DICTATION_EP.endpointer_portable_lstm_mean_stddev
___usr___srec___en-US/acousticmodel/MARBLE_VOICE_ACTIONS_EP.endpointer_portable_lstm_model
___usr___srec___en-US/acousticmodel/MARBLE_DICTATION_EP.endpointer_portable_lstm_model
___usr___srec___en-US/denorm/embedded_covid_19.mfar
___usr___srec___en-US/denorm/embedded_replace_annotated_punct_words_dash.mfar
___usr___srec___en-US/denorm/embedded_class_denorm.mfar
___usr___srec___en-US/denorm/embedded_fix_ampm.mfar
___usr___srec___en-US/denorm/porn_normalizer_on_device.mfar
___usr___srec___en-US/denorm/embedded_normalizer.mfar
___usr___srec___en-US/endtoendmodel/marble_rnnt_model.syms.compact
___usr___srec___en-US/endtoendmodel/marble_rnnt_model-rnnt.joint.tflite
___usr___srec___en-US/endtoendmodel/marble_rnnt_model-encoder.part_0.tflite
___usr___srec___en-US/endtoendmodel/marble_rnnt_model-rnnt.decoder.tflite
___usr___srec___en-US/endtoendmodel/marble_rnnt_voice_actions_frontend_params.mean_stddev
___usr___srec___en-US/endtoendmodel/marble_rnnt_model.word_classifier
___usr___srec___en-US/endtoendmodel/marble_rnnt_model.wpm.portable
___usr___srec___en-US/endtoendmodel/marble_rnnt_model-encoder.part_1.tflite
___usr___srec___en-US/endtoendmodel/marble_rnnt_dictation_frontend_params.mean_stddev
___usr___srec___en-US/context_prebuilt/en-US_android-auto_manual_fixes_STD_FST.fst
___usr___srec___en-US/context_prebuilt/apps.txt
___usr___srec___en-US/context_prebuilt/songs.txt
___usr___srec___en-US/context_prebuilt/en-US_android-auto_car_automation.action.union_STD_FST.fst
___usr___srec___en-US/context_prebuilt/contacts.txt
___usr___srec___en-US/context_prebuilt/en-US_android-auto_top_radio_station_frequencies_STD_FST.fst
___usr___srec___en-US/configs/ONDEVICE_MEDIUM_SHORT_compiler.config
___usr___srec___en-US/configs/ONDEVICE_MEDIUM_CONTINUOUS.config
___usr___srec___en-US/configs/ONDEVICE_MEDIUM_SHORT.config
___usr___srec___en-US/voice_match/MARBLE_speakerid.tflite
___lib/libjni_latinimegoogle.so
___lib64/libjni_latinimegoogle.so
___app___LatinIMEGooglePrebuilt/LatinIMEGooglePrebuilt.apk
___usr___share___ime___google___d3_lms/ko_2018030706.zip
___usr___share___ime___google___d3_lms/zh_CN_2018030706.zip
___usr___share___ime___google___d3_lms/mozc.data
"

remove_overlays() {
   for i in $delete_overlays; do
       delete_overlays "$i" "$propFilePath" "$package_title" 
   done
}

remove_existing_package() {
   # remove the existing folder for clean install of GBoard
   delete_package "LatinIMEGooglePrebuilt" "$package_title" 
}

remove_aosp_apps() {
   # Delete the folders that we want to remove with installing GBoard
   for i in $remove_aosp_apps_from_rom; do
       RemoveAospAppsFromRom "$i" "$propFilePath" "$package_title" 
   done
}

install_package() {
   remove_existing_package
   remove_aosp_apps
   remove_overlays
   # Create folders and set the permissions
   make_dir "usr"
   make_dir "usr/srec"
   make_dir "usr/srec/en-US"
   make_dir "lib"
   make_dir "lib64"
   make_dir "app"
   make_dir "app/LatinIMEGooglePrebuilt"
   make_dir "usr/share"
   make_dir "usr/share/ime"
   make_dir "usr/share/ime/google"
   make_dir "usr/share/ime/google/d3_lms"

   delete_prop_lines "$propFilePath"

   # Copy the files and set the permissions
   for i in $file_list; do
       install_file "$i"
   done


   set_prop "ro.com.google.ime.theme_id" "5" "$product/etc/build.prop" "$propFilePath" "$package_title"
   set_prop "ro.com.google.ime.kb_pad_port_b" "8" "$product/etc/build.prop" "$propFilePath" "$package_title"
   set_prop "ro.com.google.ime.kb_pad_port_l" "11" "$product/etc/build.prop" "$propFilePath" "$package_title"
   set_prop "ro.com.google.ime.kb_pad_port_r" "11" "$product/etc/build.prop" "$propFilePath" "$package_title"
   set_prop "ro.com.google.ime.height_ratio" "1.025" "$product/etc/build.prop" "$propFilePath" "$package_title"
   set_prop "ro.com.google.ime.system_lm_dir" "$install_partition/usr/share/ime/google/d3_lms" "$product/etc/build.prop" "$propFilePath" "$package_title"
             
   chmod 755 "$COMMONDIR/addon";
   update_prop "$propFilePath" "install" "$propFilePath" "GBoard" 
   . $COMMONDIR/addon "GBoard" "$propFilePath" "09"
   copy_file "$propFilePath" "$logDir/addonfiles/$package_title.prop"
}

find_install_mode

