#!/sbin/sh

uninstall_package() {
    # Remove the files when we're uninstalling NiKGapps
    for i in $file_list; do
        uninstall_file "$i" "$package_title"
    done
    # Removing the addon sh so it doesn't get backed up and restored
    for i in $(find /system/addon.d -iname "*$package_title.sh" 2>/dev/null;); do
      if [ -f "$i" ]; then
        addToLog "- Removing $i" "$package_title"
        rm -rf "$i"
      fi
    done
    # Removing the updates and residue
    if [ -n "$2" ]; then
        for i in $(find /data -iname "*$2*" 2>/dev/null); do
            if [ -e "$i" ] || [ -d "$1"]; then
                addToLog "- contents matching $2 found at $i"
                rm -rf "$i"
            fi
        done
    fi
}

# Initialize the variables
clean_flash_only="true"
title="LatinIMEGooglePrebuilt"
package_title="GBoard"
package_name="com.google.android.inputmethod.latin"

file_list="
___usr___srec___en-US/g2p_phonemes.syms
___usr___srec___en-US/g2p
___usr___srec___en-US/config.pumpkin
___usr___srec___en-US/SODA_punctuation_config.pb
___usr___srec___en-US/g2p.syms
___usr___srec___en-US/hotword.data
___usr___srec___en-US/semantics.pumpkin
___usr___srec___en-US/offline_action_data.pb
___usr___srec___en-US/metadata
___usr___srec___en-US/monastery_config.pumpkin
___usr___srec___en-US/SODA_punctuation_model.tflite
___usr___srec___en-US/pumpkin.mmap
___usr___srec___en-US/magic_mic/MARBLE_V2_acoustic_model.int8.tflite
___usr___srec___en-US/magic_mic/MARBLE_V2_model.int8.tflite
___usr___srec___en-US/magic_mic/MARBLE_V2_vocabulary.syms
___usr___srec___en-US/magic_mic/MARBLE_V2_acoustic_meanstddev_vector
___usr___srec___en-US/acousticmodel/MARBLE_VOICE_ACTIONS_EP.endpointer_portable_lstm_mean_stddev
___usr___srec___en-US/acousticmodel/MARBLE_DICTATION_EP.endpointer_portable_lstm_mean_stddev
___usr___srec___en-US/acousticmodel/MARBLE_VOICE_ACTIONS_EP.endpointer_portable_lstm_model
___usr___srec___en-US/acousticmodel/MARBLE_DICTATION_EP.endpointer_portable_lstm_model
___usr___srec___en-US/denorm/embedded_covid_19.mfar
___usr___srec___en-US/denorm/embedded_replace_annotated_punct_words_dash.mfar
___usr___srec___en-US/denorm/embedded_class_denorm.mfar
___usr___srec___en-US/denorm/embedded_fix_ampm.mfar
___usr___srec___en-US/denorm/porn_normalizer_on_device.mfar
___usr___srec___en-US/denorm/embedded_normalizer.mfar
___usr___srec___en-US/endtoendmodel/marble_rnnt_model.syms.compact
___usr___srec___en-US/endtoendmodel/marble_rnnt_model-rnnt.joint.tflite
___usr___srec___en-US/endtoendmodel/marble_rnnt_model-encoder.part_0.tflite
___usr___srec___en-US/endtoendmodel/marble_rnnt_model-rnnt.decoder.tflite
___usr___srec___en-US/endtoendmodel/marble_rnnt_voice_actions_frontend_params.mean_stddev
___usr___srec___en-US/endtoendmodel/marble_rnnt_model.word_classifier
___usr___srec___en-US/endtoendmodel/marble_rnnt_model.wpm.portable
___usr___srec___en-US/endtoendmodel/marble_rnnt_model-encoder.part_1.tflite
___usr___srec___en-US/endtoendmodel/marble_rnnt_dictation_frontend_params.mean_stddev
___usr___srec___en-US/context_prebuilt/en-US_android-auto_manual_fixes_STD_FST.fst
___usr___srec___en-US/context_prebuilt/apps.txt
___usr___srec___en-US/context_prebuilt/songs.txt
___usr___srec___en-US/context_prebuilt/en-US_android-auto_car_automation.action.union_STD_FST.fst
___usr___srec___en-US/context_prebuilt/contacts.txt
___usr___srec___en-US/context_prebuilt/en-US_android-auto_top_radio_station_frequencies_STD_FST.fst
___usr___srec___en-US/configs/ONDEVICE_MEDIUM_SHORT_compiler.config
___usr___srec___en-US/configs/ONDEVICE_MEDIUM_CONTINUOUS.config
___usr___srec___en-US/configs/ONDEVICE_MEDIUM_SHORT.config
___usr___srec___en-US/voice_match/MARBLE_speakerid.tflite
___lib/libjni_latinimegoogle.so
___lib64/libjni_latinimegoogle.so
___app___LatinIMEGooglePrebuilt/LatinIMEGooglePrebuilt.apk
___usr___share___ime___google___d3_lms/ko_2018030706.zip
___usr___share___ime___google___d3_lms/zh_CN_2018030706.zip
___usr___share___ime___google___d3_lms/mozc.data
"

uninstall_package
