#!/system/bin/sh

# Riru Vars
MAGISKTMP="$(magisk --path)"
RIRU_MODULE_LIB_NAME="pixelify"
RIRU_MODULE_ID_PRE24="%%%RIRU_MODULE_ID_PRE24%%%"

# Variables for customize.sh
RIRU_API=0
RIRU_MIN_COMPATIBLE_API=0
RIRU_VERSION_CODE=0
RIRU_VERSION_NAME=""

# Used by /data/adb/riru/util_functions.sh
RIRU_MODULE_API_VERSION=25
RIRU_MODULE_MIN_API_VERSION=25
RIRU_MODULE_MIN_RIRU_VERSION_NAME="v25.4.2"
# Riru vars end

# 1 - Normal, 2 - Zygisk, 3 - Riru
MODULE_TYPE=1
CURR="NONE"
REMOVE=""

if [ -z $API ]; then
  API=$(getprop ro.build.version.sdk)
fi

# Versions
PCSVERSION=1
NEW_JN_PL=0
DPVERSIONP=1
LWVERSIONP=1.8
PLVERSIONP=1
NGAVERSIONP=1.3

# Default size
PCSSIZE="15 Mb"
NGASIZE="13.6 Mb"
LWSIZE="108 Mb"
PLSIZE="5 Mb"
OSRSIZE="172 Mb"

# Default variables
FIRST_ONLINE_TIME=0
FORCED_ONLINE=0
BETA_BUILD=1
DISABLE_GBOARD_GMS=0
DPAS=1
ENABLE_OSR=0
DOES_NOT_REQ_SPEECH_PACK=1
INS_PCS=0
MONET_BOOTANIMATION=0
NEW_PL=0
NOT_REQ_SOUND_PATCH=0
NO_VK=1
OSRVERSIONP=1
SEND_DPS=0
SHOW_GSS=1
TARGET_DEVICE_ONEUI=0
TARGET_DEVICE_OP12=0
WALL_DID=0
WNEED=0
WREM=1
ZYGISK_P=0
PIXEL_SPOOF=0
TARGET_LOGGING=0
LOS_FIX=0
REQ_FIX=0
NEW_D_PL=0
TURN_OFF_SEL_VOL_PROMPT=0
KEEP_PIXEL_2021=0
TARGET_USE_GPHOTOS_FUNC_OVERRIDE=0

# Tensor
if [[ "$(getprop ro.soc.model)" == "Tensor" || "$(getprop ro.soc.model)" == "GS201" ]]; then
  TENSOR=1
  RIRU_LIB_PATH="$MODPATH/lib/riru_tensor"
  ZYGISK_LIB_PATH="$MODPATH/lib/zygisk_tensor"
else
  TENSOR=0
  RIRU_LIB_PATH="$MODPATH/lib/riru"
  ZYGISK_LIB_PATH="$MODPATH/lib/zygisk"
fi

# Default Locations
if [ -d /data/data/com.google.android.gms ]; then
  DE_DATA=/data/data
else
  DE_DATA=/data/user/0
fi

if [ -z $sqlite ]; then
  if [ ! -z $MODPATH ]; then
    sqlite=$MODPATH/addon/sqlite3
  else
    sqlite=/data/adb/modules/Pixelify/addon/sqlite3
  fi
  chmod 0755 $sqlite
fi

PIXELIFYUNS=/data/adb/modules/PixelifyUninstaller
FIT=$DE_DATA/com.google.android.apps.fitness/shared_prefs/growthkit_phenotype_prefs.xml
TURBO=$DE_DATA/com.google.android.apps.turbo/shared_prefs/phenotypeFlags.xml
DIALER=com.google.android.dialer
GBOARD=$DE_DATA/com.google.android.inputmethod.latin/shared_prefs/flag_value.xml
PL_PREF=$DE_DATA/com.google.android.apps.nexuslauncher/shared_prefs/com.android.launcher3.prefs.xml
NEW_GBOARD=$DE_DATA/com.google.android.inputmethod.latin/shared_prefs/flag_override.xml
FORCE_FILE="/sdcard/Pixelify/apps.txt"
SPDB="$DE_DATA/com.google.android.as/databases/superpacks.db"
DIALER_PREF=$DE_DATA/com.google.android.dialer/shared_prefs/dialer_phenotype_flags.xml
GOOGLE_PREF=$DE_DATA/com.google.android.googlequicksearchbox/shared_prefs/GEL.GSAPrefs.xml
#gmsorg=$DE_DATA/com.google.android.gms/databases/phenotype.db
gms=$DE_DATA/com.google.android.gms/databases/phenotype.db
gser=$DE_DATA/com.google.android.gsf/databases/gservices.db
gah=$DE_DATA/com.google.android.gms/databases/google_account_history.db
pix=/data/pixelify
logfile=/sdcard/Pixelify/logs.txt
PHOTOS_PREF=$DE_DATA/com.google.android.apps.photos/shared_prefs/com.google.android.apps.photos.phenotype.xml

#BIN
TTSBIN=0a136175746f67656e5f656e2d55535f763330303832f1010a05656e2d55531205656e2d55531a4968747470733a2f2f646c2e676f6f676c652e636f6d2f616e64726f69642f766f6963652f736f64612f656e2d55532f76333030362f736f64612d656e2d55532d76333030362e7a697020be1728e9d9023210736f64612d656e2d55532d76333030363836406462403338393644444235363334364433454143313141313943463034453530443934333631373044374646384139393935303742353042423844383230394531374178017802780378047805780678078a01283034384135314133413930344641443745334144453143374431433134463242323734313736453632f1010a0564652d4445120564652d44451a4968747470733a2f2f646c2e676f6f676c652e636f6d2f616e64726f69642f766f6963652f736f64612f64652d44452f76333030322f736f64612d64652d44452d76333030322e7a697020ba1728b680043210736f64612d64652d44452d76333030323836406462404145353835394142393745434542343332373735323343454145304535304438393331453946354635363731383436463641383243434346334132413630423178017802780378047805780678078a01283343383944333731444134353433353135443239394532423439354231343332434541443444424532f1010a0565732d4553120565732d45531a4968747470733a2f2f646c2e676f6f676c652e636f6d2f616e64726f69642f766f6963652f736f64612f65732d45532f76333030302f736f64612d65732d45532d76333030302e7a697020b81728b881033210736f64612d65732d45532d76333030303836406462403530383634353045333237453439384330433537444345464435304443313943393830464634303444334542393830343745324231443641433242463543333978017802780378047805780678078a01283446353534433531343336323035353235443538353139333239383730454339303235383234444332f1010a0566722d4652120566722d46521a4968747470733a2f2f646c2e676f6f676c652e636f6d2f616e64726f69642f766f6963652f736f64612f66722d46522f76333030322f736f64612d66722d46522d76333030322e7a697020ba1728b780043210736f64612d66722d46522d76333030323836406462403544344638394430344631433135373335344146303439354346454339453045423041393442363745444245383334453639353142374334383141353134354478017802780378047805780678078a01284536413741423145334642413242394143453031314143324441423834303745413432424239353532f1010a0569742d4954120569742d49541a4968747470733a2f2f646c2e676f6f676c652e636f6d2f616e64726f69642f766f6963652f736f64612f69742d49542f76333030302f736f64612d69742d49542d76333030302e7a697020b81728ada5033210736f64612d69742d49542d76333030303836406462403330363245324239454134413137394632303736424534343043354335443436333730303637364532434143453533353534353335384132363238454338433278017802780378047805780678078a01283138443235443536314646333044434441464343413837443745463742303834433430304235344532f1010a056a612d4a5012056a612d4a501a4968747470733a2f2f646c2e676f6f676c652e636f6d2f616e64726f69642f766f6963652f736f64612f6a612d4a502f76333030332f736f64612d6a612d4a502d76333030332e7a697020bb1728cc98063210736f64612d6a612d4a502d76333030333836406462403937463537393043304243454433464331423244303737363133303844364342303441303443393937394237353334304242383739334146393330344342323278017802780378047805780678078a01284233453631323538393133374330434243393744433737364142363246363341464630453038413832f1010a05656e2d41551205656e2d41551a4968747470733a2f2f646c2e676f6f676c652e636f6d2f616e64726f69642f766f6963652f736f64612f656e2d41552f76333030332f736f64612d656e2d41552d76333030332e7a697020bb1728c2d6023210736f64612d656e2d41552d76333030333836406462403130354344383338354533413330373744443542393942433537334545313041343430304637344336373439363532463032464639453837393245384439314178017802780378047805780678078a01283941364135363637423641324441393632463545373334423943453545333334424139434232334532f1010a05656e2d47421205656e2d47421a4968747470733a2f2f646c2e676f6f676c652e636f6d2f616e64726f69642f766f6963652f736f64612f656e2d47422f76333030322f736f64612d656e2d47422d76333030322e7a697020ba1728f4d6023210736f64612d656e2d47422d76333030323836406462404644383239344142324442394141454545303033394632423832344632433333384231463046424231353843353830444637463930373935374146444236433478017802780378047805780678078a01283946363744383035353135314332303236363044444332354234423444344634343243453139414232f1010a05656e2d49451205656e2d49451a4968747470733a2f2f646c2e676f6f676c652e636f6d2f616e64726f69642f766f6963652f736f64612f656e2d49452f76333030322f736f64612d656e2d49452d76333030322e7a697020ba1728f4d6023210736f64612d656e2d49452d76333030323836406462403832383637443545453446394233334230384632374342324235384338384339343835453333313141373831453037333632383633464233463445323430313878017802780378047805780678078a01283641353332433044354443433137463937463734393933333444463745464535374443463744464632f1010a05656e2d53471205656e2d53471a4968747470733a2f2f646c2e676f6f676c652e636f6d2f616e64726f69642f766f6963652f736f64612f656e2d53472f76333030312f736f64612d656e2d53472d76333030312e7a697020b91728f4d6023210736f64612d656e2d53472d76333030313836406462403434413246383033464631383438464145303737414338423342344641434533393031443946463534313938374543424541444642464641393044324438423178017802780378047805780678078a01283445324638344536393645454145343833443230374132343442444538444532453545343930384132f1010a0564652d4445120564652d44451a4968747470733a2f2f646c2e676f6f676c652e636f6d2f616e64726f69642f766f6963652f736f64612f64652d44452f76333030332f736f64612d64652d44452d76333030332e7a697020bb1728aa80043210736f64612d64652d44452d76333030333836406462403041464136423341373145313937383933334443363944363642383535393639444135453844433044304238443444304641364538463633453531393732333678017802780378047805780678078a01283437334146453333303344323735443330444639324639453145413036344645323141344141443232f1010a0566722d4652120566722d46521a4968747470733a2f2f646c2e676f6f676c652e636f6d2f616e64726f69642f766f6963652f736f64612f66722d46522f76333030332f736f64612d66722d46522d76333030332e7a697020bb1728bbd9063210736f64612d66722d46522d76333030333836406462403641394436383742313142354231373631373336333032393431333037393445373536373045394643373844463433463935454135313646434239373846433278017802780378047805780678078a01283134443135443644334538413333413331313942364242384236363044313044423244363237344632f1010a056a612d4a5012056a612d4a501a4968747470733a2f2f646c2e676f6f676c652e636f6d2f616e64726f69642f766f6963652f736f64612f6a612d4a502f76333030342f736f64612d6a612d4a502d76333030342e7a697020bc1728a4c8033210736f64612d6a612d4a502d76333030343836406462403531453533453732453744433546303643333437384133454430303531373042364234463741323936354635423237454243463039433838324238434546394278017802780378047805780678078a01283238443339343545304243423236424335453337364637364144373938463831394531384130433432f5010a05656e2d55531205656e2d55531a4968747470733a2f2f646c2e676f6f676c652e636f6d2f616e64726f69642f766f6963652f736f64612f656e2d55532f76333030382f736f64612d656e2d55532d76333030382e7a697020c01728e9d9023214736f64612d656e2d55532d76333030382d6635343836406462403933373733393136333044423330364145463338314544433032314134443942433639433032303946464143463036353843383931313834373044444341373178017802780378047805780678078a012836434342384431453742363146413234304530323030363739423943314435383736463533383643
ATLASBIN=0a0c61746c61732d6d6f64656c7312a401126268747470733a2f2f646c2e676f6f676c652e636f6d2f68666d2f5a4a62336c493831326f333752714c4d5170627951456a39663730614f45466e344a32797243706e53515969694a50624b484a42414e4475636f494e343039672f7632352e7a697020c5abd1082a28353163633339303734636266643937306431623162626631633166613232626162383030376263383a0f646574656374696f6e5f6d6f64656c1880c60a50b7f5af8b066a08080010022080f524
ASIBIN=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
XATUBIN=0a0608d83610bf3e
GOOGLEBIN=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
ATSBIN=0a0241450a0241460a0241470a02414e0a02434e0a0243570a0253580a0242510a02414f0a0241520a0241540a0241550a0241570a0242410a0242420a0242440a0242450a0242460a0242470a0242480a02424a0a02424f0a0242520a0242530a0242570a0242590a02425a0a0243410a0243480a0243490a02434c0a02434d0a02434f0a0243520a0243560a02435a0a0244450a02444b0a02444f0a0245430a0245450a0245470a0245530a0246490a02464a0a0246520a0247410a0247420a0247450a0247480a0247520a0247540a0247570a02484b0a02484e0a0248520a0248540a0248550a0249440a0249450a02494c0a0249510a02494e0a0249540a024a4d0a024a4f0a024a500a024b450a024b470a024b480a024b520a024b570a024b5a0a024c410a024c420a024c490a024c4b0a024c540a024c550a024c560a024c590a024d410a024d440a024d4b0a024d4c0a024d4d0a024d4e0a024d540a024d550a024d580a024d590a024d5a0a024e410a024e450a024e470a024e490a024e4c0a024e4f0a024e500a024e5a0a024f4d0a0250410a0250450a0250470a0250480a02504b0a02504c0a0250520a0250540a0250590a0251410a0252450a02524f0a0252530a0252550a0252570a0253410a0253450a0253470a0253490a02534b0a02534e0a0253560a0254470a0254480a02544a0a0254520a0254540a0254570a02545a0a0255410a0255470a0255530a0255590a0256450a02564e0a0259450a025a410a025a4d0a025a57
REVBIN=0a0b686f6c2d776176656e65740a0b6a6d702d776176656e65740a0b6a61622d776176656e65740a0b6a61642d776176656e65740a0b6465652d776176656e65740a0b6465662d776176656e65740a0b6166682d776176656e65740a0b6175622d776176656e65740a0b6175642d776176656e65740a0b6669732d776176656e65740a0b6762682d776176656e65740a0b6378782d776176656e65740a0b656e622d776176656e65740a0b636c6f75642d65732d65732d776176656e65742d620a0b6e68672d776176656e65740a0b6366652d776176656e65740a0b6672622d776176656e65740a0b6672652d776176656e65740a0b63666e2d776176656e65740a0b6869642d776176656e65740a0b616d622d776176656e65740a0b6974612d776176656e65740a0b6a61612d776176656e65740a0b6d666b2d776176656e65740a0b
TKBIN=0a0a746b2d646174617365741276124068747470733a2f2f73746f726167652e676f6f676c65617069732e636f6d2f6469616c65722d746b2f70726f642f746b5f646174617365745f7631352e7a697020bab7332a28663031323836396639636435316562376531336262363230663331353364333861346164366461373a04646174611880a305500f6a08080010022080f524
GSPOOF=0a064f72696f6c650a066f72696f6c650a05526176656e0a08506978656c20362a0a08506978656c20372a0a08506978656c20352a

if [ $API -le 28 ]; then
  product=
else
  product=/product
fi

# Patching flags
ASI_FLAGS="AmbientContext__enable
AmbientContext__enable_quick_tap
Captions__enable_augmented_modality
Captions__enable_augmented_modality_input
Captions__text_transform_augmented_input
Cell__enable_cell	
Cell__enable_pnb_aggregation
Cell__enable_search_events
Cell__enable_smartspace_events
EchoSearch__enable_dota
EchoSearch__enable_dota_asset
EchoSearch__enable_horizontal_people_shortcuts
EchoSearch__enable_packer_fallback_targets_parallel_run
EchoSearch__enable_pnb
EchoSearch__enable_search_fa_logging
EchoSearch__enable_shortcut_filter
EchoSmartspace__check_notification_visibility
EchoSmartspace__enable_add_internal_feedback_button
EchoSmartspace__enable_flight_landing_smartspace_aiai
EchoSmartspace__enable_hotel_smartspace_aiai
EchoSmartspace__enable_media_recs_for_driving
EchoSmartspace__enable_predictor_expiration
EchoSmartspace__runtastic_check_pause_action
EchoSmartspace__runtastic_is_ongoing_default_true
EchoSmartspace__smartspace_enable_daily_forecast
EchoSmartspace__smartspace_enable_timely_reminder
EchoSmartspace__strava_check_stop_action
EchoSmartspace__enable_agsa_settings_read	
EchoSmartspace__enable_cross_feature_rank_dedup_twiddler	
EchoSmartspace__enable_dimensional_logging	
EchoSmartspace__enable_encode_subcard_into_smartspace_target_id
EchoSmartspace__enable_ring_channels_regex	
EchoSmartspace__enable_ring_using_ui_template
Echo__avatar_enable_feature
Echo__enable_headphones_suggestions_from_agsa
Echo__enable_people_module
Echo__enable_widget_recommendations
Echo__toast_enable_mdd
Echo__search_enable_all_fallback_results
Echo__search_enable_allowlist
Echo__search_enable_app_fetcher_v2
Echo__search_enable_app_search_tips
Echo__search_enable_app_usage_stats_ranking
Echo__search_enable_application_header_type
Echo__search_enable_apps
Echo__search_enable_appsearch_tips_ranking_improvement
Echo__search_enable_assistant_quick_phrases_settings
Echo__search_enable_bc_smartspace_settings
Echo__search_enable_bc_translate_settings
Echo__search_enable_eventstore
Echo__search_enable_everything_else_above_web
Echo__search_enable_fetcher_optimization_using_result_types
Echo__search_enable_filter_pending_jobs
Echo__search_enable_mdp_play_results
Echo__search_enable_play
Echo__search_enable_play_alleyoop
Echo__search_enable_scraping
Echo__search_enable_search_in_app_icon
Echo__search_enable_settings_corpus
Echo__search_enable_shortcuts
Echo__search_enable_superpacks_app_terms
Echo__search_enable_superpacks_play_results
Echo__search_enable_top_hit_row
Echo__search_enable_widget_corpus
Echo__search_play_enable_spell_correction
Echo__smartspace_dedupe_fast_pair_notification
Echo__smartspace_enable_async_icon
Echo__smartspace_enable_battery_notification_parser
Echo__smartspace_enable_bedtime_active_predictor
Echo__smartspace_enable_bedtime_reminder_predictor
Echo__smartspace_enable_bluetooth_metadata_parser
Echo__smartspace_enable_cross_device_timer
Echo__smartspace_enable_dark_launch_outlook_events
Echo__smartspace_enable_doorbell
Echo__smartspace_enable_doorbell_context_wrapper
Echo__smartspace_enable_doorbell_extras
Echo__smartspace_enable_dwb_bedtime_predictor
Echo__smartspace_enable_earthquake_alert_predictor
Echo__smartspace_enable_echo_settings
Echo__smartspace_enable_echo_unified_settings
Echo__smartspace_enable_eta_doordash
Echo__smartspace_enable_eta_lyft
Echo__smartspace_enable_food_delivery_eta
Echo__smartspace_enable_grocery
Echo__smartspace_enable_media_wake_lock_acquire
Echo__smartspace_enable_nap
Echo__smartspace_enable_nudge
Echo__smartspace_enable_outlook_events
Echo__smartspace_enable_package_delivery
Echo__smartspace_enable_paired_device_connections
Echo__smartspace_enable_paired_device_predictor
Echo__smartspace_enable_ridesharing_eta
Echo__smartspace_enable_safety_check_predictor
Echo__smartspace_enable_score_ranker
Echo__smartspace_enable_sensitive_notification_twiddler
Echo__smartspace_enable_step_predictor
Echo__smartspace_enable_subcard_logging
Echo__smartspace_gaia_twiddler
Echo__smartspace_show_cross_device_timer_label
Echo__smartspace_use_flashlight_action_chip
Echo_search__enable_dota
Echo_smartspace__enable_flight_landing_smartspace_aiai
Echo_smartspace__enable_hotel_smartspace_aiai
Echo_smartspace__smartspace_enable_daily_forecast
Echo_smartspace__smartspace_enable_timely_reminder
FederatedAssistant__enable_speech_personalization_caching
FederatedAssistant__enable_speech_personalization_inference
FederatedAssistant__enable_speech_personalization_training
Hopper__enable_active_notification_tracker
Hopper__enable_auto_expiration
Hopper__enable_connector
Hopper__enable_conversation_blocklist
Hopper__enable_observer
Hopper__enable_priority_suggestions
Hopper__enable_smart_action
Hopper__enable_smart_reply
Hopper__enable_text_predictor
Hopper__enable_time_based_expiration
NowPlaying__youtube_export_enabled
Notification__enable_journey_feature_vectors	
Notification__enable_mdd_playsnapshot	
Notification__enable_notification_collection	
Notification__enable_notification_journey
Overview__enable_lens_r_overview_long_press
Overview__enable_lens_r_overview_select_mode
Overview__enable_lens_r_overview_translate_action
People__enable_call_log_signals
People__enable_contacts
People__enable_dictation_client
People__enable_hybrid_hotseat_client
People__enable_notification_common
People__enable_notification_signals
People__enable_package_tracker
People__enable_people_pecan
People__enable_people_search_content
People__enable_priority_suggestion_client
People__enable_profile_signals
People__enable_sharesheet_client
People__enable_sms_signals
QuickTapMdd__enable_quick_tap
QuickTap__enable_quick_tap
Screenshot__can_use_gms_core_to_save_boarding_pass
Screenshot__can_use_gpay_to_save_boarding_pass
Screenshot__enable_add_to_wallet_title
Screenshot__enable_covid_card_action
Screenshot__enable_lens_screenshots_search_action
Screenshot__enable_lens_screenshots_similar_styles_action
Screenshot__enable_lens_screenshots_translate_action
Screenshot__enable_quick_share_smart_action
Screenshot__enable_screenshot_notification_smart_actions
SmartDictation__enable_alternatives_from_past_corrections
SmartDictation__enable_alternatives_from_speech_hypotheses
SmartDictation__enable_biasing_for_commands
SmartDictation__enable_biasing_for_contacts
SmartDictation__enable_biasing_for_contacts_learned_from_past_corrections
SmartDictation__enable_biasing_for_interests_model
SmartDictation__enable_biasing_for_past_correction
SmartDictation__enable_biasing_for_screen_context
SmartDictation__enable_selection_filtering
SmartRecCompose__enable_aiai_tc_generator
SmartRecCompose__enable_compose_action_filter
SmartRecCompose__enable_compose_tc
SmartRecCompose__enable_deep_clu_model
SmartRecOverviewChips__enable_action_boost_generator
SmartRecOverviewChips__enable_matchmaker_generator
SmartRecOverviewChips__enable_reflection_generator
SmartRecOverviewChips__enable_settings_card_generator
SmartRecOverviewChips__enable_smartrec_for_overview_chips
SmartRecPixelSearch__enable_aiai_tc_generator
SmartRecPixelSearch__enable_all_fallbacks
SmartRecPixelSearch__enable_appaction_generator
SmartRecPixelSearch__enable_assistant_geller_data_index
SmartRecPixelSearch__enable_assistant_generator
SmartRecPixelSearch__enable_assistant_personalized_deeplinks
SmartRecPixelSearch__enable_assistant_vertical_generator
SmartRecPixelSearch__enable_chrometab_generator
SmartRecPixelSearch__enable_corpora_via_search_context
SmartRecPixelSearch__enable_entity_annotation_generator
SmartRecPixelSearch__enable_entity_based_action_generation
SmartRecPixelSearch__enable_gboard_suggestion
SmartRecPixelSearch__enable_nasa_for_search
SmartRecPixelSearch__enable_navigational_sites_generator
SmartRecPixelSearch__enable_screenshot_generator
SmartRecPixelSearch__enable_screenshot_thumbnail_cache
SmartRecPixelSearch__enable_search_on_contacts
SmartRecPixelSearch__enable_spelling_correction
SmartRecPixelSearch__enable_search_system_pointer_generator	
SmartRecPixelSearch__enable_sys_pointer_nearby_share	
SmartRecPixelSearch__enable_sys_pointer_password_mgr	
SmartRecPixelSearch__enable_sys_pointer_photos
SmartRecPixelSearch__enable_sys_pointer_videos	
SmartRecPixelSearch__promote_sys_pointer_in_psb
SpeechPack__speech_recognition_service_settings_enabled	
SpeechPack__enable_mdd_download_notifications
SpeechPack__use_mdd_download_system
SmartRecQuickSearchBox__enable_action_boost_generator
SmartSelect__enable_smart_select_paste_package_signal
SmartSelect__enable_smart_select_training_manager_populations
SpeechPack__speech_recognition_service_settings_enabled
Translate__translation_service_enabled
Translate__beta_audio_to_text_languages_in_live_caption
EchoAvatar__job_scheduler_enable
EchoAvatar__module_enable
EchoSearch__enable_appsearch_photos_corpus
EchoSearch__enable_appsearch_photos_corpus_app_preview
EchoSearch__enable_appsearch_photos_corpus_app_srp_preview
EchoSmartspace__smartspace_enable_tomorrow_forecast
SmartRecPixelSearch__enable_search_on_photos
SmartRecPixelSearch__enable_search_on_files
EchoSmartspace__enable_optin_bedtime_adjustment_provider
EchoSearch__enable_dynamic_web"

DIALERFLAGS="G__enable_atlas
enable_atlas_call_audio_state_verification
enable_atlas_on_tidepods_voice_screen
show_atlas_hold_for_me_confirmation_dialog
atlas_use_soda_for_transcription
atlas_ivr_alert_use_dialpad_clicks
atlas_enable_au_business_number
atlas_show_preview_label
enable_time_keeper
enable_time_keeper_histogram
G__enable_call_screen_saving_audio
G__enable_call_recording
G__force_within_call_recording_geofence_value
G__use_call_recording_geofence_overrides
G__force_within_crosby_geofence_value
Xatu__xatu_always_uses_soda
enable_xatu
enable_xatu_music_detection
enable_dialer_hold_handling
enable_hold_detection
enable_video_calling_screen
G__new_voicemail_fragment_enabled
Xatu__xatu_enable_show_ahead
enable_time_keeper_active_download
G__enable_patronus_spam
G__are_embeddings_jobs_enabled
G__config_caller_id_enabled
G__enable_primes
Scooby__enable_same_prefix_logging
enable_stir_shaken
enable_use_async_spatula_patronus_spam
use_async_spatula_header
G__enable_tiktok_button_dialog_voice_screen
use_lightweight_executor_for_timeout_enforcement_in_soda_model_availability_impl
G__enable_tidepods__voice"

CALL_SCREEN_FLAGS="G__enable_call_screen_saving_audio
G__enable_speakeasy_details
G__speak_easy_bypass_locale_check
G__speak_easy_enabled
enable_call_screen_demo
enable_video_calling_screen
G__enable_call_screen_data_in_call_log
G__show_call_screen_recording_player_in_call_log
G__enable_call_screen_deleting_old_recordings
G__enable_reject_embedding_spam_calls
G__show_call_screen_recording_player_in_call_log"

CS_LANG="enable_call_screen_i18n_tidepods
G__enable_tidepods_revelio"

CS_REV="G__enable_revelio
G__enable_revelio_on_bluetooth
G__enable_revelio_on_wired_headset
G__bypass_revelio_roaming_check
enable_revelio_transcript
G__enable_embedding_spam_revelio"

GBOARD_FLAGS="crank_trigger_decoder_inline_completion_first
crank_trigger_decoder_inline_prediction_first
emojify_enable_fallback_pattern
enable_core_typing_experience_indicator_on_candidates
enable_core_typing_experience_indicator_on_composing_text
enable_downloadable_spell_checker_model
enable_email_provider_completion
enable_emoji_predictor_tflite_engine
enable_emoji_to_expression
enable_emoji_to_expression_tappable_ui
enable_emojify
enable_emojify_settings_option
enable_expression_candidate_precaching_for_bitmoji
enable_expression_content_cache
enable_expression_moment_push_up_animation
enable_expressive_concept_model
enable_feature_split_brella
enable_floating_keyboard_v2
enable_grammar_checker
enable_grammar_checker_on_webview
enable_handle_bitmoji_for_expression_candidates
enable_handle_emoticon_for_expression_candidates
enable_handle_expression_moment_standard_emoji_kitchen
enable_inline_suggestions_on_client_side
enable_inline_suggestions_on_decoder_side
enable_inline_suggestions_space_tooltip
enable_inline_suggestions_tooltip_v2
enable_matched_predictions_as_inline_from_crank_cifg
enable_multiword_predictions_as_inline_from_crank_cifg
enable_multiword_predictions_from_user_history
enable_multiword_suggestions_as_inline_from_crank_cifg
enable_nav_redesign
enable_nga
enable_nga_ime_api
enable_nga_language_picker_on_monolang_keyboard
enable_nga_punctuation_correction
enable_single_word_predictions_as_inline_from_crank_cifg
enable_stylus_widget
enable_text_to_one_tap_expressions
enable_trigger_spell_check_in_composing
enable_trigger_spell_check_in_sentence
enable_twiddler_multiword_engine
enable_user_history_predictions_as_inline_from_crank_cifg
enable_voice_ellipsis
hide_composing_underline
nga_enable_mic_button_when_dictation_eligible
nga_enable_mic_onboarding_animation
nga_enable_spoken_emoji_sticky_variant
nga_enable_sticky_mic
nga_enable_undo_delete
notify_emoji_candidate_availability
offline_translate
show_contextual_emoji_kitchen_in_expression_moment
show_suggestions_for_selected_text_while_dictating
translate_new_ui"

GSS_FLAGS="BatteryHi__is_enabled
BatteryUsage__is_enabled
BatteryWidget__is_widget_enabled
BatteryWidget__is_enabled
RoutinesPrototype__enable_wifi_driven_bootstrap
RoutinesPrototype__is_action_notifications_enabled
RoutinesPrototype__is_activities_enabled
RoutinesPrototype__is_module_enabled
RoutinesPrototype__is_manual_location_rule_adding_enabled
RoutinesPrototype__is_routine_inference_enabled
RoutinesPrototype__is_slices_enabled"

S_HUB_FLAGS="45351680
45351680
45353325
45353325
45354067
45354067
45354137
45354137
45354219
45354219
45354289
45354289
45354290
45354290
45354291
45354291
45354292
45354292
45355361
45355361
45356900
45356900
45356902
45356902
45357909
45357909
45359057
45359057
45359104
45359104
45359152
45359152
45359153
45359153
45359172
45359172
45359404
45359404
45359407
45359407
45362747
45362747
45351680
45353325
45354067
45354137
45354219
45354289
45354290
45354291
45354292
45355361
45356900
45356902
45357909
45359057
45359104
45359152
45359153
45359172
45359404
45359407
45362747
45351680
45353325
45354067
45354137
45354219
45354289
45354290
45354291
45354292
45355361
45356900
45356902
45357909
45359057
45359104
45359152
45359153
45359172
45359404
45359407
45362747"

overide_spoof=""
spoof_message=""

if [ $API -eq 32 ]; then
  overide_spoof="org.pixelexperience.device
org.evolution.device
ro.bliss.device
ro.cherish.device
ro.lighthouse.device
ro.ssos.device
ro.spark.device
ro.potato.device"
elif [ $API -eq 33 ]; then
  overide_spoof="org.pixelexperience.device
ro.bliss.device
ro.cherish.device
ro.ssos.device
org.voidui.device
ro.derp.device
ro.aosap.device
ro.stag.device
ro.tequila.device"
fi

device_spoof=""
pixel_spoof=""
if [ $API -ge 32 ]; then
  device_spoof="ro.xtended.version
ro.crdroid.build.version
ro.catalyst.version
ro.rice.version
ro.voltage.version
org.evolution.device
ro.alpha.build.version
ro.blaze.settings.android_version
ro.spiceos.version
ro.spark.device
ro.octavi.version
ro.bootleggers.version"

  pixel_spoof="org.eternityos.version
org.lessaospos.version
org.elixir.version
org.blaze.version
ro.conquer.version
org.eternityos.version
org.yapp.version
ro.banana.version
org.flexo.version"
fi

exact_prop=""

PIXEL_2021_ROMS="ro.lighthouse.device
ro.system.cygnus.device
ro.ryzen.version
ro.shirayuki.version
ro.aospa.version
ro.awaken.version
ro.yaap.device
ro.proton.build.version
ro.styx.version
ro.syberia.version
ro.pixeldust.version"

sound_patch='    <!-- Multiple sound_model_config tags can be listed, each with unique
         vendor_uuid. -->
    <sound_model_config>
        <param vendor_uuid="7038ddc8-30f2-11e6-b0ac-40a8f03d3f15" />
        <param execution_type="WDSP" /> <!-- value: "WDSP" "ADSP" "DYNAMIC" -->
        <param library="none" />
        <param max_cpe_phrases="1" />
        <param max_cpe_users="1" />
        <gcs_usecase>
            <param uid="0x1" />
            <param load_sound_model_ids="0x18000001, 0x1, 0x18000100" />
            <param start_engine_ids="0x18000001, 0x1, 0x18000101" />
            <param request_detection_ids="0x18000001, 0x4, 0x18000106" />
            <param detection_event_ids="0x18000001, 0x1, 0x00012C29" />
            <param read_cmd_ids="0x00020013, 0x1, 0x00020015" />
            <param read_rsp_ids="0x00020013, 0x1, 0x00020016" />
        </gcs_usecase>
        <!--  kw_duration is in milli seconds. It is valid only for FTRT
            transfer mode -->
        <param capture_keyword="PCM_raw, FTRT, 2000" />
        <param client_capture_read_delay="2000" />
    </sound_model_config>

    <!-- music -->
    <sound_model_config>
        <param vendor_uuid="9f6ad62a-1f0b-11e7-87c5-40a8f03d3f15" />
        <param execution_type="WDSP" /> <!-- value: "WDSP" "ADSP" "DYNAMIC" -->
        <param library="none" />
        <gcs_usecase>
            <param uid="0x2" />
            <param load_sound_model_ids="0x18000001, 0x1, 0x18000102" />
            <param start_engine_ids="0x18000001, 0x1, 0x18000103" />
            <param request_detection_ids="0x18000001, 0x4, 0x18000107" />
            <param custom_config_ids="0x18000001, 0x1, 0x18000106" />
            <param detection_event_ids="0x18000001, 0x1, 0x00012C29" />
            <param read_cmd_ids="0x00020013, 0x2, 0x00020015" />
            <param read_rsp_ids="0x00020013, 0x2, 0x00020016" />
        </gcs_usecase>
        <!--  kw_duration is in milli seconds. It is valid only for FTRT
            transfer mode -->
        <param capture_keyword="MULAW_raw, FTRT, 4000" />
        <param client_capture_read_delay="2000" />
    </sound_model_config>

    <sound_model_config>
        <param vendor_uuid="2fc815fa-4a42-11e7-99bd-40a8f03d3f15" />
        <param execution_type="WDSP" /> <!-- value: "WDSP" "ADSP" "DYNAMIC" -->
        <param library="none" />
        <gcs_usecase>
            <param uid="0x3" />
            <param load_sound_model_ids="0x18000001, 0x1, 0x18000104" />
            <param start_engine_ids="0x18000001, 0x1, 0x18000105" />
            <param detection_event_ids="0x18000001, 0x1, 0x00012C29" />
        </gcs_usecase>
        <!--  kw_duration is in milli seconds. It is valid only for FTRT
            transfer mode -->
        <param capture_keyword="PCM_raw, FTRT, 0" />
        <param client_capture_read_delay="0" />
    </sound_model_config>'

font1='  <family name="google-sans">
    <font weight="400" style="normal">GoogleSans-Regular.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="18.0"/>
      <axis tag="wght" stylevalue="400"/>
    </font>
    <font weight="500" style="normal">GoogleSans-Regular.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="18.0"/>
      <axis tag="wght" stylevalue="500"/>
    </font>
    <font weight="600" style="normal">GoogleSans-Regular.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="18.0"/>
      <axis tag="wght" stylevalue="600"/>
    </font>
    <font weight="700" style="normal">GoogleSans-Regular.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="18.0"/>
      <axis tag="wght" stylevalue="700"/>
    </font>
    <font weight="400" style="italic">GoogleSans-Italic.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="18.0"/>
      <axis tag="wght" stylevalue="400"/>
    </font>
    <font weight="500" style="italic">GoogleSans-Italic.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="18.0"/>
      <axis tag="wght" stylevalue="500"/>
    </font>
    <font weight="600" style="italic">GoogleSans-Italic.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="18.0"/>
      <axis tag="wght" stylevalue="600"/>
    </font>
    <font weight="700" style="italic">GoogleSans-Italic.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="18.0"/>
      <axis tag="wght" stylevalue="700"/>
    </font>
  </family>'

font2='  <family name="google-sans-medium">
    <font weight="500" style="normal">GoogleSans-Regular.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="18.0"/>
      <axis tag="wght" stylevalue="500"/>
    </font>
  </family>'

font10='  <family name="google-sans-italics-bold">
    <font weight="700" style="normal">GoogleSans-Italic.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="18.0"/>
      <axis tag="wght" stylevalue="700"/>
    </font>
  </family>'

font11='  <family name="google-sans-italics-medium">
    <font weight="500" style="normal">GoogleSans-Italic.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="18.0"/>
      <axis tag="wght" stylevalue="500"/>
    </font>
  </family>'

font12='  <family name="google-sans-italics">
    <font weight="400" style="normal">GoogleSans-Italic.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="18.0"/>
      <axis tag="wght" stylevalue="400"/>
    </font>
  </family>'

font3='  <family name="google-sans-bold">
    <font weight="700" style="normal">GoogleSans-Regular.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="18.0"/>
      <axis tag="wght" stylevalue="700"/>
    </font>
  </family>'

font4='  <family name="google-sans-text">
    <font weight="400" style="normal">GoogleSans-Regular.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="17.0"/>
      <axis tag="wght" stylevalue="400"/>
    </font>
    <font weight="500" style="normal">GoogleSans-Regular.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="17.0"/>
      <axis tag="wght" stylevalue="500"/>
    </font>
    <font weight="600" style="normal">GoogleSans-Regular.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="17.0"/>
      <axis tag="wght" stylevalue="600"/>
    </font>
    <font weight="700" style="normal">GoogleSans-Regular.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="17.0"/>
      <axis tag="wght" stylevalue="700"/>
    </font>
    <font weight="400" style="italic">GoogleSans-Italic.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="17.0"/>
      <axis tag="wght" stylevalue="400"/>
    </font>
    <font weight="500" style="italic">GoogleSans-Italic.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="17.0"/>
      <axis tag="wght" stylevalue="500"/>
    </font>
    <font weight="600" style="italic">GoogleSans-Italic.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="17.0"/>
      <axis tag="wght" stylevalue="600"/>
    </font>
    <font weight="700" style="italic">GoogleSans-Italic.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="17.0"/>
      <axis tag="wght" stylevalue="700"/>
    </font>
  </family>'

font5='  <family name="google-sans-text-medium">
    <font weight="500" style="normal">GoogleSans-Regular.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="17.0"/>
      <axis tag="wght" stylevalue="500"/>
    </font>
  </family>'

font6='  <family name="google-sans-text-bold">
    <font weight="700" style="normal">GoogleSans-Regular.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="17.0"/>
      <axis tag="wght" stylevalue="700"/>
    </font>
  </family>'

font7='  <family name="google-sans-text-italic">
    <font weight="400" style="italic">GoogleSans-Italic.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="17.0"/>
      <axis tag="wght" stylevalue="400"/>
    </font>
  </family>'

font8='  <family name="google-sans-text-medium-italic">
    <font weight="500" style="italic">GoogleSans-Italic.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="17.0"/>
      <axis tag="wght" stylevalue="500"/>
    </font>
  </family>'

font9='  <family name="google-sans-text-bold-italic">
    <font weight="700" style="italic">GoogleSans-Italic.ttf
      <axis tag="GRAD" stylevalue="0"/>
      <axis tag="opsz" stylevalue="17.0"/>
      <axis tag="wght" stylevalue="700"/>
    </font>
  </family>'

gfont1='    <family customizationType="new-named-family" name="google-sans-inter">
      <font weight="400" style="normal">GInterVF-Roman.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="18.0"/>
        <axis tag="wght" stylevalue="400"/>
      </font>
      <font weight="500" style="normal">GInterVF-Roman.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="18.0"/>
        <axis tag="wght" stylevalue="500"/>
      </font>
      <font weight="600" style="normal">GInterVF-Roman.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="18.0"/>
        <axis tag="wght" stylevalue="600"/>
      </font>
      <font weight="700" style="normal">GInterVF-Roman.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="18.0"/>
        <axis tag="wght" stylevalue="700"/>
      </font>
      <font weight="400" style="italic">GInterVF-Italic.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="18.0"/>
        <axis tag="wght" stylevalue="400"/>
      </font>
      <font weight="500" style="italic">GInterVF-Italic.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="18.0"/>
        <axis tag="wght" stylevalue="500"/>
      </font>
      <font weight="600" style="italic">GInterVF-Italic.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="18.0"/>
        <axis tag="wght" stylevalue="600"/>
      </font>
      <font weight="700" style="italic">GInterVF-Italic.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="18.0"/>
        <axis tag="wght" stylevalue="700"/>
      </font>
    </family>'

gfont2='    <family customizationType="new-named-family" name="google-sans-medium-inter">
      <font weight="500" style="normal">GInterVF-Roman.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="18.0"/>
        <axis tag="wght" stylevalue="500"/>
      </font>
    </family>'

gfont3='    <family customizationType="new-named-family" name="google-sans-bold-inter">
      <font weight="700" style="normal">GInterVF-Roman.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="18.0"/>
        <axis tag="wght" stylevalue="700"/>
      </font>
    </family>'

gfont4='    <family customizationType="new-named-family" name="google-sans-text-inter">
      <font weight="400" style="normal">GInterVF-Roman.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="17.0"/>
        <axis tag="wght" stylevalue="400"/>
      </font>
      <font weight="500" style="normal">GInterVF-Roman.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="17.0"/>
        <axis tag="wght" stylevalue="500"/>
      </font>
      <font weight="600" style="normal">GInterVF-Roman.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="17.0"/>
        <axis tag="wght" stylevalue="600"/>
      </font>
      <font weight="700" style="normal">GInterVF-Roman.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="17.0"/>
        <axis tag="wght" stylevalue="700"/>
      </font>
      <font weight="400" style="italic">GInterVF-Italic.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="17.0"/>
        <axis tag="wght" stylevalue="400"/>
      </font>
      <font weight="500" style="italic">GInterVF-Italic.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="17.0"/>
        <axis tag="wght" stylevalue="500"/>
      </font>
      <font weight="600" style="italic">GInterVF-Italic.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="17.0"/>
        <axis tag="wght" stylevalue="600"/>
      </font>
      <font weight="700" style="italic">GInterVF-Italic.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="17.0"/>
        <axis tag="wght" stylevalue="700"/>
      </font>
    </family>'

gfont5='    <family customizationType="new-named-family" name="google-sans-text-medium-inter">
      <font weight="500" style="normal">GInterVF-Roman.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="17.0"/>
        <axis tag="wght" stylevalue="500"/>
      </font>
    </family>'

gfont6='    <family customizationType="new-named-family" name="google-sans-text-bold-inter">
      <font weight="700" style="normal">GInterVF-Roman.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="17.0"/>
        <axis tag="wght" stylevalue="700"/>
      </font>
    </family>'

gfont7='    <family customizationType="new-named-family" name="google-sans-text-italic-inter">
      <font weight="400" style="italic">GInterVF-Italic.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="17.0"/>
        <axis tag="wght" stylevalue="400"/>
      </font>
    </family>'

gfont8='    <family customizationType="new-named-family" name="google-sans-text-medium-italic-inter">
      <font weight="500" style="italic">GInterVF-Italic.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="17.0"/>
        <axis tag="wght" stylevalue="500"/>
      </font>
    </family>'

gfont9='    <family customizationType="new-named-family" name="google-sans-text-bold-italic-inter">
      <font weight="700" style="italic">GInterVF-Italic.ttf
        <axis tag="GRAD" stylevalue="0"/>
        <axis tag="opsz" stylevalue="17.0"/>
        <axis tag="wght" stylevalue="700"/>
      </font>
    </family>'

var_menu="
=====================
Installation Menu
=====================
[-] Unused in Installation
[O] Enabled
[X] Disabled
=====================
FORCE_ENABLE_ONLINE [-]
DISABLE_INTERNAL_SPOOFING [-]
ENABLE_PHOTOS_UNLIMITED [-]
ENABLE_PIXEL_SPOOFING [-]
TARGET_USES_PIXEL5_SPOOF [-]
TARGET_USES_PIXEL6_SPOOF [-]
ENABLE_DPS [-]
UPDATE_DPS [-]
BACKUP_DPS [-]
ENABLE_NOW_PLAYING [-]
ENABLE_DIALER_FEATURES [-]
ADD_CALL_SCREENING_FILES [-]
BACKUP_CALL_SCREENING_FILES [-]
ENABLE_NGA [-]
UPDATE_NGA_RES [-]
DOWNLOAD_NGA_RES [-]
BACKUP_NGA [-]
DOWNLOAD_OSR [-]
UPDATE_OSR [-]
BACKUP_OSR [-]
DOWN_WGA [-]
ENABLE_LIVE_WALLPAPERS [-]
DOWNLOAD_LIVE_WALLPAPERS [-]
BACKUP_LIVE_WALLPAPERS [-]
ENABLE_BOOTANIMATION [-]
ENABLE_PIXEL_LAUNCHER [-]
UPDATE_PIXEL_LAUNCHER [-]
BACKUP_PIXEL_LAUNCHER [-]
ENABLE_GSI [-]
DISABLE_GBOARD_GMS_OVERRIDE [-]
ENABLE_EXTREME_BATTERY_SAVER [-]
========================
"
